package com.biz.crm.cps.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 商品物料关系表
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("product_material")
@Api(tags = "商品与物料关系实体")
public class ProductMaterial extends UuidFlagOpEntity {
  private static final long serialVersionUID = 5464770324499219286L;

  /**
   * 物料数量
   *
   * @Column(name = "num", nullable = false, length = 10, columnDefinition = "int(10) COMMENT ' 物料数量
   * '")
   */
  @ApiModelProperty("物料数量")
  @TableField(value = "num")
  private Integer num;

  /**
   * 物料编码
   *
   * @Column(name = "material_code", nullable = false, length = 64, columnDefinition = "varchar(64)
   * COMMENT ' 物料编码 '")
   */
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 商品编码
   *
   * @Column(name = "product_code", nullable = false, length = 64, columnDefinition = "varchar(64)
   * COMMENT ' 商品编码 '")
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  private String productCode;

  /**
   * 比例
   *
   * @Column(name = "ratio", nullable = true, columnDefinition = "decimal(10, 2) COMMENT ' 比例 '")
   */
  @ApiModelProperty("比例")
  @TableField(value = "ratio")
  private BigDecimal ratio;
  /**
   * 物料
   */
  @ApiModelProperty("物料")
  @TableField(exist = false)
  private Material material;
  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  @TableField(value = "external_identifier")
  private String externalIdentifier;
  /**
   * 商品
   */
  @ApiModelProperty("商品")
  @TableField(exist = false)
  private Product product;
}
