package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.MaterialGroup;
import org.apache.ibatis.annotations.Param;

/**
 * 物料组信息 的 mybatis-plus接口类 {@link MaterialGroup}
 *
 * @author hecheng
 */
public interface MaterialGroupMapper extends BaseMapper<MaterialGroup> {

  /**
   * 根据 MaterialGroup 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  MaterialGroup findDetailsById(@Param("id") String id);

  /**
   * 根据materialGroupCode物料组编码 查询（包括关联表）
   *
   * @param materialGroupCode
   * @return
   */
  MaterialGroup findByMaterialGroupCode(@Param("materialGroupCode") String materialGroupCode);

}
