package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.MaterialGroup;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 物料组物料关系信息 的 mybatis-plus接口类 {@link MaterialGroupRel}
 *
 * @author hecheng
 */
public interface MaterialGroupRelMapper extends BaseMapper<MaterialGroupRel> {

  /**
   * 根据 MaterialGroup 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  MaterialGroupRel findDetailsById(@Param("id") String id);

  /**
   * 根据materialGroupCode物料组编码 查询（包括关联表）
   *
   * @param materialGroupCode
   * @return
   */
  List<MaterialGroupRel> findByMaterialGroupCode(@Param("materialGroupCode") String materialGroupCode);

  /**
   * 根据materialCode物料编码 查询（包括关联表）
   * @param materialCode
   * @return
   */
  List<MaterialGroupRel> findByMaterialCode(@Param("materialCode") String materialCode);
}
