package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.Material;

import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * 物料信息 的 mybatis-plus接口类 {@link Material}
 *
 * @author hecheng
 */
public interface MaterialMapper extends BaseMapper<Material> {

  /**
   * 根据 Material 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  Material findDetailsById(@Param("id") String id);

  /**
   * 根据materialCodewl物料编码 查询（包括关联表）
   *
   * @param materialCode
   * @return
   */
  Material findByMaterialCode(@Param("materialCode") String materialCode);

  /**
   * 根据productLevelCode层级编码 查询（包括关联表）
   *
   * @param productLevelCode
   * @return
   */
  List<Material> findByProductLevelCode(@Param("productLevelCode") String productLevelCode);

  /**
   * 按层级ruleCode集合查询物料 包含孩子
   * @param ruleCodes
   * @return
   */
  List<Material> findAllChildrenByRuleCodes(@Param("ruleCodes")List<String> ruleCodes);
}
