package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.entity.MaterialMedia;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 物料图片信息 的 mybatis-plus接口类 {@link MaterialMedia}
 *
 * @author hecheng
 */
public interface MaterialMediaMapper extends BaseMapper<MaterialMedia> {

  /**
   * 根据 MaterialMedia 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  MaterialMedia findDetailsById(@Param("id") String id);

  /**
   * 根据materialCodewl物料编码 查询（包括关联表）
   *
   * @param materialCode
   * @return
   */
  List<MaterialMedia> findByMaterialCode(@Param("materialCode") String materialCode);

}
