package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import org.apache.ibatis.annotations.Param;

/**
 * 商品层级 的 mybatis-plus接口类 {@link ProductLevel}
 *
 * @author hecheng
 */
public interface ProductLevelMapper extends BaseMapper<ProductLevel> {

  /**
   * 根据 productLevel 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  ProductLevel findDetailsById(@Param("id") String id);

  /**
   * 根据productLevelCode层级编码 查询（包括关联表）
   *
   * @param productLevelCode
   * @return
   */
  ProductLevel findByProductLevelCode(@Param("productLevelCode") String productLevelCode);

  /**
   * 根据parentCode父级编码  查询（包括关联表）
   *
   * @param parentCode
   * @return
   */
  ProductLevel findByParentCode(@Param("parentCode") String parentCode);
}
