package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.product.local.entity.Product;

import com.biz.crm.cps.business.product.sdk.dto.ProductPaginationDto;

import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * 商品 的 mybatis-plus接口类 {@link Product}
 *
 * @author hecheng
 */
public interface ProductMapper extends BaseMapper<Product> {

  /**
   * 根据主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  Product findDetailsById(@Param("id") String id);

  /**
   * 根据productCode 产品编码 查询详细信息（包括关联表）
   *
   * @param productCode
   * @return
   */
  Product findByProductCode(@Param("productCode") String productCode);

  /**
   * 根据productLevelCode 产品层级编码 查询详细信息（包括关联表）
   *
   * @param productLevelCode
   * @return
   */
  List<Product> findByProductLevelCode(@Param("productLevelCode") String productLevelCode);

  /**
   * 按条件分页查询商品
   * @param page
   * @param productPaginationDto
   * @return
   */
  Page<Product> findByConditions(Page<Product> page,@Param("dto") ProductPaginationDto productPaginationDto);
}
