package com.biz.crm.cps.business.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;

import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * 商品与物料关系 的 mybatis-plus接口类 {@link ProductMaterial}
 *
 * @author hecheng
 */
public interface ProductMaterialMapper extends BaseMapper<ProductMaterial> {

  /**
   * 根据materialCode物料编码 查询（包括关联表）
   *
   * @param materialCode
   * @return
   */
  List<ProductMaterial> findByMaterialCode(@Param("materialCode") String materialCode);

  /**
   * 根据productCode商品编码 查询（包括关联表）
   *
   * @param productCode
   * @return
   */
  List<ProductMaterial> findByProductCode(@Param("productCode") String productCode);
}
