package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.mapper.MaterialGroupRelMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 物料组关系信息 的 数据库访问类 {@link MaterialGroupRel}
 *
 * @author hecheng
 */
@Component
public class MaterialGroupRelRepository extends ServiceImpl<MaterialGroupRelMapper, MaterialGroupRel> {

  /**
   * 根据主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  public MaterialGroupRel findDetailsById(String id) {
    return this.baseMapper.findDetailsById(id);
  }

  /**
   * 按物料组code查询
   *
   * @param materialGroupCode
   * @return
   */
  public List<MaterialGroupRel> findByMaterialGroupCode(String materialGroupCode) {
    return this.baseMapper.findByMaterialGroupCode(materialGroupCode);
  }

  /**
   * 按物料code查询
   *
   * @param materialCode
   * @return
   */
  public List<MaterialGroupRel> findByMaterialCode(String materialCode) {
    return this.baseMapper.findByMaterialCode(materialCode);
  }

  /**
   * 按物料组code 删除物料关系
   *
   * @param materialGroupCode
   */
  public void deleteByMaterialGroupCode(String materialGroupCode) {
    this.lambdaUpdate().eq(MaterialGroupRel::getMaterialGroupCode, materialGroupCode).remove();
  }

  /**
   * 按物料组编码集合查询
   * @param materialGroupCodes
   * @return
   */
  public List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes) {
    return this.lambdaQuery().in(MaterialGroupRel::getMaterialGroupCode,materialGroupCodes).list();
  }
}
