package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.product.local.entity.MaterialGroup;
import com.biz.crm.cps.business.product.local.mapper.MaterialGroupMapper;
import org.springframework.stereotype.Component;

/**
 * 物料组信息 的 数据库访问类 {@link MaterialGroup}
 *
 * @author hecheng
 */
@Component
public class MaterialGroupRepository extends ServiceImpl<MaterialGroupMapper, MaterialGroup> {

  /**
   * 根据主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  public MaterialGroup findDetailsById(String id) {
    return this.baseMapper.findDetailsById(id);
  }

  /**
   * 按物料组code查询
   *
   * @param materialGroupCode
   * @return
   */
  public MaterialGroup findByMaterialGroupCode(String materialGroupCode) {
    return this.baseMapper.findByMaterialGroupCode(materialGroupCode);
  }


}
