package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.product.local.entity.MaterialMedia;
import com.biz.crm.cps.business.product.local.mapper.MaterialMediaMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 物料媒体信息 的 数据库访问类 {@link MaterialMedia}
 *
 * @author hecheng
 */
@Component
public class MaterialMediaRepository extends ServiceImpl<MaterialMediaMapper, MaterialMedia> {

  /**
   * 根据主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  public MaterialMedia findDetailsById(String id) {
    return this.baseMapper.findDetailsById(id);
  }

  /**
   * 按物料code查询
   *
   * @param materialCode
   * @return
   */
  public List<MaterialMedia> findByMaterialCode(String materialCode) {
    return this.baseMapper.findByMaterialCode(materialCode);
  }

  /**
   * 按物料code 删除
   *
   * @param materialCode
   */
  public void deleteByMaterialCode(String materialCode) {
    this.lambdaUpdate().eq(MaterialMedia::getMaterialCode, materialCode).remove();
  }
}
