package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.mapper.MaterialMapper;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 物料信息 的 数据库访问类 {@link Material}
 *
 * @author hecheng
 */
@Component
public class MaterialRepository extends ServiceImpl<MaterialMapper, Material> {

  /**
   * 根据主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  public Material findDetailsById(String id) {
    return this.baseMapper.findDetailsById(id);
  }

  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<Material> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 根据materialCodewl物料编码 查询（包括关联表）
   *
   * @param materialCode
   * @return
   */
  public Material findByMaterialCode(String materialCode) {
    return this.baseMapper.findByMaterialCode(materialCode);
  }

  /**
   * 根据productLevelCode层级编码 查询（包括关联表）
   *
   * @param productLevelCode
   * @return
   */
  public List<Material> findByProductLevelCode(String productLevelCode) {
    return this.baseMapper.findByProductLevelCode(productLevelCode);
  }

  /**
   * 根据materialCode编码集合 查询
   *
   * @param materialCodes
   * @return
   */
  public List<Material> findByMaterialCodes(List<String> materialCodes) {
    return this.lambdaQuery().in(Material::getMaterialCode, materialCodes).list();
  }

  /**
   * 按id集合查询物料信息
   *
   * @param ids
   * @return
   */
  public List<Material> findByIds(List<String> ids) {
    return this.lambdaQuery().in(Material::getId, ids).list();
  }

  /**
   * 按物料层级集合查询物料
   * @param productLevelCodes
   * @return
   */
  public List<Material> findByProductLevelCodes(List<String> productLevelCodes) {
    return this.lambdaQuery().in(Material::getProductLevelCode, productLevelCodes).list();
  }

  /**
   * 按层级ruleCode集合查询物料 包含孩子
   * @param ruleCodes
   * @return
   */
  public List<Material> findAllChildrenByRuleCodes(List<String> ruleCodes) {
    return this.baseMapper.findAllChildrenByRuleCodes(ruleCodes);
  }
}
