package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.mapper.ProductMaterialMapper;

import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 商品与物料关系实体 的 数据库访问类 {@link ProductMaterial}
 *
 * @author hecheng
 */
@Component
public class ProductMaterialRepository extends ServiceImpl<ProductMaterialMapper, ProductMaterial> {

  /**
   * 根据materialCode物料编码 查询（包括关联表）
   *
   * @param materialCode
   * @return
   */
  public List<ProductMaterial> findByMaterialCode(String materialCode) {
    return this.baseMapper.findByMaterialCode(materialCode);
  }

  /**
   * 根据productCode商品编码 查询（包括关联表）
   *
   * @param productCode
   * @return
   */
  public List<ProductMaterial> findByProductCode(String productCode) {
    return this.baseMapper.findByProductCode(productCode);
  }

  /**
   * 根据productCode商品编码集合 查询
   *
   * @param productCodes
   * @return
   */
  public List<ProductMaterial> findByProductCodes(List<String> productCodes) {
    return this.lambdaQuery().in(ProductMaterial::getProductCode, productCodes).list();
  }

  /**
   * 根据productCode商品编码删除商品物料关系
   *
   * @param productCode
   */
  public void deleteByProductCode(String productCode) {
    this.lambdaUpdate().eq(ProductMaterial::getProductCode, productCode).remove();
  }
}
