package com.biz.crm.cps.business.product.local.service;

import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import java.util.List;

/**
 * 物料组关系service
 *
 * @author hecheng
 */
public interface MaterialGroupRelService {

  /**
   * 创建一个新的MaterialGroupRel模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  MaterialGroupRel create(MaterialGroupRel materialGroupRel);

  /**
   * 批量创建一个新的MaterialGroupRel模型对象
   * @param materialGroupRels
   */
  void createBatch(List<MaterialGroupRel> materialGroupRels);

  /**
   * 按照MaterialGroupRel的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  MaterialGroupRel findById(String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  MaterialGroupRel findDetailsById(String id);

  /**
   * 通过物料code查询
   * @param materialCode
   * @return
   */
  List<MaterialGroupRel> findByMaterialCode(String materialCode);

  /**
   * 按物料组编码集合查询
   * @param materialGroupCodes
   * @return
   */
  List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes);
}
