package com.biz.crm.cps.business.product.local.service;

import com.biz.crm.cps.business.product.local.entity.MaterialGroup;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import org.springframework.data.domain.Pageable;

/**
 * 物料组service
 *
 * @author hecheng
 */
public interface MaterialGroupService {

  /**
   * 创建一个新的MaterialGroup模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  MaterialGroup create(MaterialGroup materialGroup);

  /**
   * 更新一个已有的MaterialGroup模型对象，其主键属性必须有值。 这个方法实际上一共分为三个步骤（默认）：</br> 1、调用updateValidation方法完成表单数据更新前的验证</br> 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br> 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  MaterialGroup update(MaterialGroup materialGroup);


  /**
   * 按照MaterialGroup的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  MaterialGroup findById(String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  MaterialGroup findDetailsById(String id);

  /**
   * 按照MaterialGroup的materialGroupCode物料组编码，查询指定的数据信息（不包括任何关联信息）
   *
   * @param materialGroupCode 物料组编码
   */
  MaterialGroup findByMaterialGroupCode(String materialGroupCode);

  /**
   * 根据条件从mdm侧拉取数据，并存入cps侧系统
   * 从指定页 开始 拉去到最后一页
   * @param pageable
   * @param materialGroupMdmPaginationDto
   */
  void sync(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto);
}
