package com.biz.crm.cps.business.product.local.service;

import com.biz.crm.cps.business.product.local.entity.MaterialMedia;
import java.util.List;

/**
 * 物料图片service
 *
 * @author hecheng
 */
public interface MaterialMediaService {

  /**
   * 批量创建一个新的MaterialMedia模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  void createBatch(List<MaterialMedia> materialMedias);

  /**
   * 按照MaterialMedia的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  MaterialMedia findById(String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  MaterialMedia findDetailsById(String id);

  /**
   * 按物料code查询物料图片
   *
   * @param materialCode
   * @return
   */
  List<MaterialMedia> findByMaterialCode(String materialCode);

}
