package com.biz.crm.cps.business.product.local.service;

import com.biz.crm.cps.business.product.local.entity.ProductMaterial;

import java.util.List;

/**
 * 商品与物料关系service
 *
 * @author hecheng
 */
public interface ProductMaterialService {


  /**
   * 批量录入商品与物料关系信息
   *
   * @param productMaterials
   * @return
   */
  void createBatch(List<ProductMaterial> productMaterials);

  /**
   * 创建或者更新
   *
   * @param target
   */
  void saveBatch(List<ProductMaterial> target);

  /**
   * 按照ProductMaterial的materialCode物料编码，查询指定的数据信息（不包括任何关联信息）
   *
   * @param materialCode 物料编码
   */
  List<ProductMaterial> findByMaterialCode(String materialCode);

  /**
   * 按照ProductMaterial的productCode商品编码，查询指定的数据信息（不包括任何关联信息）
   *
   * @param productCode 商品编码
   */
  List<ProductMaterial> findByProductCode(String productCode);


}
