package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.repository.MaterialGroupRelRepository;
import com.biz.crm.cps.business.product.local.service.MaterialGroupRelService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 物料组关系service实现
 * @date 2021/8/23 下午4:08
 */
@Service
public class MaterialGroupRelServiceImpl implements MaterialGroupRelService {

  @Autowired
  private MaterialGroupRelRepository materialGroupRelRepository;

  @Transactional
  @Override
  public MaterialGroupRel create(MaterialGroupRel materialGroupRel) {
    MaterialGroupRel current = this.createForm(materialGroupRel);
    this.materialGroupRelRepository.save(current);
    return current;
  }

  @Transactional
  @Override
  public void createBatch(List<MaterialGroupRel> materialGroupRels) {
    Validate.notEmpty(materialGroupRels, "物料组关系不能为空");
    Map<String, List<MaterialGroupRel>> materialMediaMap = materialGroupRels.stream().collect(Collectors.groupingBy(MaterialGroupRel::getMaterialGroupCode));
    for (Map.Entry<String, List<MaterialGroupRel>> entry : materialMediaMap.entrySet()) {
      String materialGroupCode = entry.getKey();
      List<MaterialGroupRel> tempMaterialRels = entry.getValue();
      List<MaterialGroupRel> old = this.materialGroupRelRepository.findByMaterialGroupCode(materialGroupCode);
      if (!CollectionUtils.isEmpty(old)) {
        this.materialGroupRelRepository.deleteByMaterialGroupCode(materialGroupCode);
      }
      for (MaterialGroupRel materialGroup : tempMaterialRels) {
        this.createForm(materialGroup);
      }
      this.materialGroupRelRepository.saveBatch(tempMaterialRels);
    }
  }

  /**
   * 构造对象
   *
   * @param materialGroupRel
   * @return
   */
  private MaterialGroupRel createForm(MaterialGroupRel materialGroupRel) {
    Date now = new Date();
    String account = this.getLoginAccountName();
    materialGroupRel.setCreateAccount(account);
    materialGroupRel.setCreateTime(now);
    materialGroupRel.setModifyAccount(account);
    materialGroupRel.setModifyTime(now);
    this.createValidation(materialGroupRel);
    this.createValidation(materialGroupRel);
    if (StringUtils.isBlank(materialGroupRel.getDelFlag())) {
      materialGroupRel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    }
    if (StringUtils.isBlank(materialGroupRel.getEnableStatus())) {
      materialGroupRel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
    return materialGroupRel;
  }

  @Override
  public MaterialGroupRel findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.materialGroupRelRepository.getById(id);
  }

  @Override
  public MaterialGroupRel findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.materialGroupRelRepository.findDetailsById(id);
  }

  @Override
  public List<MaterialGroupRel> findByMaterialCode(String materialCode) {
    if (StringUtils.isBlank(materialCode)) {
      return null;
    }
    return this.materialGroupRelRepository.findByMaterialCode(materialCode);
  }

  @Override
  public List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes) {
    Validate.notEmpty(materialGroupCodes,"物料组编码集合不能为空");
    return this.materialGroupRelRepository.findByMaterialGroupCodes(materialGroupCodes);
  }

  /**
   * 数据校验
   *
   * @param materialGroupRel
   */
  private void createValidation(MaterialGroupRel materialGroupRel) {
    Validate.notNull(materialGroupRel, "进行当前操作时，信息对象必须传入!!");
    materialGroupRel.setId(null);
    Validate.notNull(materialGroupRel.getMaterialGroupCode(), "添加信息时，物料组编码不能为空！");
    Validate.notNull(materialGroupRel.getMaterialCode(), "添加信息时，物料编码不能为空！");
  }

  /**
   * 获取当前登录人名称
   *
   * @return
   */
  private String getLoginAccountName() {
    SecurityContext context = SecurityContextHolder.getContext();
    String account = "admin";
    if (context != null && context.getAuthentication() != null) {
      account = context.getAuthentication().getName();
    }
    return account;
  }
}
