package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.service.MaterialGroupService;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.business.product.local.service.MaterialTaskService;
import com.biz.crm.cps.business.product.sdk.common.constant.MaterialDimensionConstant;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 物料同步任务
 * @date 2021/9/30 下午5:47
 */
@Service
@Slf4j
public class MaterialTaskServiceImpl implements MaterialTaskService {

  @Autowired
  private MaterialService materialService;
  @Autowired
  private MaterialGroupService materialGroupService;

  @Override
  @DynamicTaskService(cornExpression = "0 0 0 1 * ?", taskDesc = "每日同步物料任务")
  public void sync() {
    try {
      MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
      Pageable pageable = PageRequest.of(1, MaterialDimensionConstant.SYNC_SIZE);
      this.materialService.sync(pageable, dto);
      Pageable pageableGroup = PageRequest.of(1, MaterialDimensionConstant.SYNC_SIZE);
      MaterialGroupMdmPaginationDto groupDto = new MaterialGroupMdmPaginationDto();
      this.materialGroupService.sync(pageableGroup, groupDto);
    } catch (RuntimeException e) {
      log.error("同步物料失败！" + e.getMessage(), e);
    }
  }
}
