package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.repository.ProductMaterialRepository;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 商品与物料关系service
 * @date 2021/8/9 下午3:33
 */
@Service
public class ProductMaterialServiceImpl implements ProductMaterialService {

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private ProductMaterialRepository productMaterialRepository;

  /**
   * 校验
   *
   * @param productMaterial
   * @return
   */
  private ProductMaterial createForm(ProductMaterial productMaterial) {
    Date now = new Date();
    String account = this.getLoginAccountName();
    productMaterial.setCreateAccount(account);
    productMaterial.setCreateTime(now);
    productMaterial.setModifyAccount(account);
    productMaterial.setModifyTime(now);
    this.createValidation(productMaterial);
    return productMaterial;
  }

  @Transactional
  @Override
  public void createBatch(List<ProductMaterial> productMaterials) {
    if (CollectionUtils.isEmpty(productMaterials)) {
      return;
    }
    for (ProductMaterial productMaterial : productMaterials) {
      this.createForm(productMaterial);
    }
    this.productMaterialRepository.saveBatch(productMaterials);
  }

  @Transactional
  @Override
  public void saveBatch(List<ProductMaterial> target) {
    //
    if (!CollectionUtils.isEmpty(target)) {
      Map<String, List<ProductMaterial>> productMaterialMap = target.stream()
              .collect(Collectors.groupingBy(ProductMaterial::getProductCode));
      for (Map.Entry<String, List<ProductMaterial>> entry : productMaterialMap.entrySet()) {
        String productCode = entry.getKey();
        List<ProductMaterial> productMaterials = entry.getValue();
        List<ProductMaterial> old = productMaterialRepository.findByProductCode(productCode);
        if (!CollectionUtils.isEmpty(old)) {
          productMaterialRepository.deleteByProductCode(productCode);
        }
        this.createBatch(productMaterials);
      }
    }
  }

  @Override
  public List<ProductMaterial> findByMaterialCode(String materialCode) {
    if (StringUtils.isBlank(materialCode)) {
      return null;
    }
    return productMaterialRepository.findByMaterialCode(materialCode);
  }

  @Override
  public List<ProductMaterial> findByProductCode(String productCode) {
    if (StringUtils.isBlank(productCode)) {
      return null;
    }
    return productMaterialRepository.findByProductCode(productCode);
  }

  /**
   * 数据校验
   *
   * @param productMaterial
   */
  private void createValidation(ProductMaterial productMaterial) {
    Validate.notNull(productMaterial, "进行当前操作时，信息对象必须传入!!");
    productMaterial.setId(null);
    Validate.notNull(productMaterial.getNum(), "添加信息时，物料数量不能为空！");
    Validate.notBlank(productMaterial.getMaterialCode(), "添加信息时，物料编码不能为空！");
    Validate.notBlank(productMaterial.getProductCode(), "添加信息时，商品编码不能为空！");
    //    Validate.notNull(productMaterial.getRatio(), "添加信息时，比例不能为空！");
    Validate.isTrue(productMaterial.getNum() > 0, "物料数量必须大于0，请检查!");

  }

  /**
   * 获取当前登录人名称
   *
   * @return
   */
  private String getLoginAccountName() {
    SecurityContext context = SecurityContextHolder.getContext();
    String account = "admin";
    if (context != null && context.getAuthentication() != null) {
      account = context.getAuthentication().getName();
    }
    return account;
  }
}
