package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.Product;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.repository.ProductRepository;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.biz.crm.cps.business.product.sdk.dto.ProductDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.cps.business.product.sdk.service.ProductVoService;
import com.biz.crm.cps.business.product.sdk.vo.ProductDimensionVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductLevelVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author hecheng
 * @description:商品voservice实现
 * @date 2021/8/7 下午3:59
 */
@Service
public class ProductVoServiceImpl implements ProductVoService {

  @Autowired
  private ProductRepository productRepository;
  @Autowired
  private ProductLevelService productLevelService;
  @Autowired
  private ProductMaterialService productMaterialService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public ProductDimensionVo findByProductCode(String productCode) {
    //填充商品维度Vo
    //1.填充商品基础信息
    //2.填充商品物料信息
    //3.填充商品层级信息
    if (StringUtils.isBlank(productCode)) {
      return null;
    }
    Product product = this.productRepository.findByProductCode(productCode);
    if (product == null) {
      return null;
    }

    ProductDimensionVo vo = this.nebulaToolkitService
            .copyObjectByWhiteList(product, ProductDimensionVo.class,
                    Set.class, ArrayList.class);
    vo.setProductMaterials(Sets.newHashSet());
    List<ProductMaterial> productMaterials = productMaterialService
            .findByProductCode(product.getProductCode());
    if (!CollectionUtils.isEmpty(productMaterials)) {
      List<ProductMaterialVo> productMaterialVos = (List<ProductMaterialVo>) this.nebulaToolkitService
              .copyCollectionByWhiteList(productMaterials, ProductMaterial.class,
                      ProductMaterialVo.class, HashSet.class,
                      ArrayList.class
              );
      vo.setProductMaterials(Sets.newHashSet(productMaterialVos));
    }

    if (StringUtils.isNotBlank(product.getProductLevelCode())) {
      List<ProductLevel> productLevelList = this.productLevelService
              .findAllParentsByProductLevelCode(product.getProductLevelCode());
      if (!CollectionUtils.isEmpty(productLevelList)) {
        List<ProductLevelVo> productLevelVos = (List<ProductLevelVo>) this.nebulaToolkitService
                .copyCollectionByWhiteList(productLevelList, ProductLevel.class,
                        ProductLevelVo.class, HashSet.class,
                        ArrayList.class);
        vo.setProductLevels(Sets.newHashSet(productLevelVos));
      }
    }
    return vo;
  }

  @Override
  public String getDimensionCode(ProductDimensionDto productDimensionDto, String productLevelType) {
    if (productDimensionDto != null) {
      if (!CollectionUtils.isEmpty(productDimensionDto.getProductLevels())) {
        return productDimensionDto.getProductLevels().stream().filter(item -> {
          return Objects.equals(item.getProductLevelType(), productLevelType);
        }).findFirst().orElse(new ProductLevelDto()).getProductLevelCode();
      }
    }
    return null;
  }
}
