package com.biz.crm.cps.business.product.local.service.notifier;

import com.biz.crm.cps.business.product.sdk.common.enums.MaterialStandardUnitTypeEnum;
import com.biz.crm.cps.business.product.sdk.dto.MaterialStandardUnitDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.BarCodeMaterialStandardEventListener;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialStandardUnitVo;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 条码模块查询物料信息事件实现
 * @date 2021/9/9 下午2:46
 */
@Service("BarCodeMaterialStandardEventListenerImpl")
public class BarCodeMaterialStandardEventListenerImpl implements BarCodeMaterialStandardEventListener {

  @Autowired
  private MaterialStandardUnitVoService materialStandardUnitVoService;

  @Autowired
  private MaterialVoService materialVoService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<BarCodeMaterialStandardUnitVo> onRequestMaterialStandardUnit(List<BarCodeEventDto> dtos) {
    if (CollectionUtils.isEmpty(dtos)) {
      return null;
    }
    List<MaterialStandardUnitDto> materialStandardUnitDtos = dtos.stream().map(item -> {
      MaterialStandardUnitDto vo = new MaterialStandardUnitDto();
      vo.setBarCode(item.getBarCode());
      vo.setBarCodeType(item.getBarCodeType());
      vo.setMaterialCode(item.getProductCode());
      return vo;
    }).collect(Collectors.toList());
    List<MaterialStandardUnitVo> vos = materialStandardUnitVoService.findByBarCodeAndBarCodeType(materialStandardUnitDtos);
    if (CollectionUtils.isEmpty(vos)) {
      return null;
    }
    List<BarCodeMaterialStandardUnitVo> barCodeMaterialStandardUnitVos = vos.stream().map(item -> {
      BarCodeMaterialStandardUnitVo vo = this.nebulaToolkitService.copyObjectByWhiteList(item, BarCodeMaterialStandardUnitVo.class, HashSet.class, ArrayList.class);
      if (MaterialStandardUnitTypeEnum.CASE.getKey().equals(vo.getStandardUnitType())) {
        vo.setStandardUnitBoxValue(item.getStandardUnitValue());
        if (BarCodeTypeEnum.BOTTLE.getFlag().equals(vo.getBarCodeType())) {
          vo.setStandardUnitBottleValue(BigDecimal.ONE);
        }
      }
      if (MaterialStandardUnitTypeEnum.BOX.getKey().equals(vo.getStandardUnitType())) {
        vo.setStandardUnitBottleValue(item.getStandardUnitValue());
        if (BarCodeTypeEnum.BOX.getFlag().equals(vo.getBarCodeType())) {
          vo.setStandardUnitBoxValue(BigDecimal.ONE);
        }
      }
      vo.setProductCode(item.getMaterialCode());
      return vo;
    }).collect(Collectors.toList());
    return barCodeMaterialStandardUnitVos;
  }

  @Override
  public BarCodeMaterialVo onRequestMaterial(BarCodeEventDto dto) {
    if (StringUtils.isEmpty(dto.getProductCode())) {
      return null;
    }
    MaterialDimensionVo materialDimensionVo = this.materialVoService.findByMaterialCode(dto.getProductCode());
    if (ObjectUtils.isEmpty(materialDimensionVo)) {
      return null;
    }
    BarCodeMaterialVo barCodeMaterialVo = new BarCodeMaterialVo();
    barCodeMaterialVo.setProductCode(dto.getProductCode());
    barCodeMaterialVo.setProductLevelCode(materialDimensionVo.getProductLevelCode());
    return barCodeMaterialVo;
  }
}
