/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.entity.MaterialMedia;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.repository.MaterialRepository;
import com.biz.crm.cps.business.product.local.service.MaterialMediaService;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialStandardUnitTypeEnum;
import com.biz.crm.cps.business.product.sdk.event.MaterialEventListener;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeVo;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMediaMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialServiceImpl
implements MaterialService {
    private static final Logger log = LoggerFactory.getLogger(MaterialServiceImpl.class);
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private MaterialRepository materialRepository;
    @Autowired
    private MaterialMediaService materialMediaService;
    @Autowired
    private ProductLevelService productLevelService;
    @Autowired(required=false)
    private List<MaterialEventListener> materialEventListenerList;
    @Autowired(required=false)
    private MaterialMdmService materialMdmService;
    @Autowired(required=false)
    private BarCodeVoService barCodeVoService;

    @Override
    @Transactional
    public Material create(Material material) {
        Material current = this.createForm(material);
        this.materialRepository.save((Object)current);
        return current;
    }

    @Override
    public Material createForm(Material material) {
        String materialCode;
        Date now = new Date();
        String account = this.getLoginAccountName();
        material.setTenantCode(TenantUtils.getTenantCode());
        material.setCreateAccount(account);
        material.setCreateTime(now);
        material.setModifyAccount(account);
        material.setModifyTime(now);
        this.createValidation(material);
        if (StringUtils.isBlank((CharSequence)material.getDelFlag())) {
            material.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)material.getEnableStatus())) {
            material.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isBlank((CharSequence)(materialCode = material.getMaterialCode()))) {
            materialCode = (String)this.generateCodeService.generateCode("material", 1).get(0);
            material.setMaterialCode(materialCode);
        }
        return material;
    }

    @Override
    public Material update(Material material) {
        Material current = this.updateForm(material);
        return current;
    }

    @Override
    @Transactional
    public Material updateForm(Material material) {
        this.updateValidation(material);
        String currentId = material.getId();
        String materialCode = material.getMaterialCode();
        Material current = null;
        if (StringUtils.isNotBlank((CharSequence)currentId)) {
            current = (Material)((Object)this.materialRepository.getById((Serializable)((Object)currentId)));
        } else if (StringUtils.isNotBlank((CharSequence)materialCode)) {
            current = this.findByMaterialCode(materialCode);
        }
        current = (Material)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        MaterialVo oldVo = null;
        if (!CollectionUtils.isEmpty(this.materialEventListenerList)) {
            oldVo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        BeanUtils.copyProperties((Object)((Object)material), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.materialRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.materialEventListenerList)) {
            MaterialVo newVo = (MaterialVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (MaterialEventListener event : this.materialEventListenerList) {
                event.onChange(oldVo, newVo);
            }
        }
        return current;
    }

    @Override
    public Material findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Material)((Object)this.materialRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Material findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.materialRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.materialRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.materialEventListenerList)) {
            List<Material> terminals = this.materialRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminals, Material.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (MaterialEventListener event : this.materialEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    @Transactional
    public List<Material> createBatch(List<Material> materials) {
        if (!CollectionUtils.isEmpty(materials)) {
            for (Material material : materials) {
                this.createForm(material);
            }
            this.materialRepository.saveBatch(materials);
            return materials;
        }
        return Lists.newArrayList();
    }

    private List<Material> updateBatch(List<Material> materials) {
        if (!CollectionUtils.isEmpty(materials)) {
            for (Material material : materials) {
                this.updateForm(material);
            }
            return materials;
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public void saveBatch(List<Material> target) {
        if (!CollectionUtils.isEmpty(target)) {
            List<String> materialCodes = target.stream().map(Material::getMaterialCode).distinct().collect(Collectors.toList());
            List<Object> oldList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(materialCodes)) {
                oldList = this.materialRepository.findByMaterialCodes(materialCodes);
            }
            ArrayList addList = Lists.newArrayList();
            ArrayList needUpdateList = Lists.newArrayList();
            ArrayList delList = Lists.newArrayList();
            this.nebulaToolkitService.collectionDiscrepancy(target, (Collection)oldList, Material::getMaterialCode, (Collection)delList, (Collection)needUpdateList, (Collection)addList);
            this.createBatch(addList);
            if (!CollectionUtils.isEmpty((Collection)needUpdateList)) {
                List needUpdateCodeList = needUpdateList.stream().map(Material::getMaterialCode).collect(Collectors.toList());
                List<Material> updateList = target.stream().filter(item -> needUpdateCodeList.contains(item.getMaterialCode())).collect(Collectors.toList());
                this.updateBatch(updateList);
            }
        }
    }

    @Override
    public Material findByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        return this.materialRepository.findByMaterialCode(materialCode);
    }

    @Override
    public List<Material> findByProductLevelCode(String productLevelCode) {
        if (StringUtils.isBlank((CharSequence)productLevelCode)) {
            return null;
        }
        return this.materialRepository.findByProductLevelCode(productLevelCode);
    }

    @Override
    @Transactional
    public void sync(Pageable pageable, MaterialMdmPaginationDto materialMdmPaginationDto) {
        boolean isQuery = true;
        int pageNumber = pageable.getPageNumber() - 1;
        while (isQuery) {
            int pageSize = pageable.getPageSize();
            PageRequest pageRequest = PageRequest.of((int)(++pageNumber), (int)pageSize);
            Page page = this.materialMdmService.findByConditions((Pageable)pageRequest, materialMdmPaginationDto);
            this.syncDataHandle(page.getRecords());
            if (page.getRecords().size() >= pageSize) continue;
            isQuery = false;
        }
    }

    @Override
    public void syncDataHandle(List<MaterialMdmVo> materialMdmVos) {
        if (CollectionUtils.isEmpty(materialMdmVos)) {
            log.info("\u540c\u6b65\u7269\u6599\u65f6\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
            return;
        }
        List productLevelMdmVos = materialMdmVos.stream().flatMap(item -> item.getProductLevels().stream()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductLevelMdmVo>(Comparator.comparing(ProductLevelMdmVo::getId))), ArrayList::new));
        List mediaMdmVos = materialMdmVos.stream().flatMap(item -> item.getMaterialMedias().stream()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MaterialMediaMdmVo>(Comparator.comparing(MaterialMediaMdmVo::getId))), ArrayList::new));
        this.bulidProductLevel(productLevelMdmVos);
        this.bulidMaterial(materialMdmVos);
        this.bulidMaterialMedia(mediaMdmVos);
    }

    @Override
    public List<Material> findByMaterialCodes(List<String> materialCodes) {
        if (CollectionUtils.isEmpty(materialCodes)) {
            return null;
        }
        return this.materialRepository.findByMaterialCodes(materialCodes);
    }

    @Override
    public List<Material> findByProductLevelCodes(List<String> productLevelCodes) {
        if (CollectionUtils.isEmpty(productLevelCodes)) {
            return null;
        }
        return this.materialRepository.findByProductLevelCodes(productLevelCodes);
    }

    @Override
    public List<Material> findAllChildrenByProductLevelCodes(List<String> productLevelCodes) {
        if (CollectionUtils.isEmpty(productLevelCodes)) {
            return null;
        }
        List<ProductLevel> levels = this.productLevelService.findByProductLevelCodes(productLevelCodes);
        if (CollectionUtils.isEmpty(levels)) {
            return null;
        }
        List<String> ruleCodes = levels.stream().map(ProductLevel::getRuleCode).distinct().collect(Collectors.toList());
        return this.materialRepository.findAllChildrenByRuleCodes(ruleCodes);
    }

    @Override
    public String findStandardUnitByBarCodeAndBarCodeType(String barCode, String barCodeType) {
        if (StringUtils.isBlank((CharSequence)barCode) || StringUtils.isBlank((CharSequence)barCodeType)) {
            return null;
        }
        BarCodeVo barCodeVo = this.barCodeVoService.findByBarCode(barCode);
        if (Objects.isNull(barCodeVo)) {
            return null;
        }
        Material material = this.materialRepository.findByMaterialCode(barCodeVo.getProductCode());
        if (Objects.isNull((Object)material)) {
            return null;
        }
        String unit = "~";
        MaterialStandardUnitTypeEnum standardUnitEnum = MaterialStandardUnitTypeEnum.getByKey((String)material.getStandardUnit());
        String standardUnit = Objects.isNull(standardUnitEnum) ? "" : standardUnitEnum.getValue();
        BigDecimal boxUnitConversion = material.getBoxUnitConversion();
        BigDecimal caseUnitConversion = material.getCaseUnitConversion();
        if (Objects.isNull(boxUnitConversion) || Objects.isNull(caseUnitConversion)) {
            return unit;
        }
        if (Objects.equals(barCodeType, BarCodeTypeEnum.BOTTLE.getFlag())) {
            unit = boxUnitConversion.toString() + standardUnit;
        } else if (Objects.equals(barCodeType, BarCodeTypeEnum.BOX.getFlag())) {
            unit = caseUnitConversion.toString() + standardUnit;
        }
        return unit;
    }

    @Override
    public List<Material> findAll() {
        return this.materialRepository.list();
    }

    private void bulidProductLevel(List<ProductLevelMdmVo> productLevelMdmVos) {
        if (!CollectionUtils.isEmpty(productLevelMdmVos)) {
            List<ProductLevel> target = productLevelMdmVos.stream().map(item -> {
                ProductLevel productLevel = (ProductLevel)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(item, ProductLevel.class, HashSet.class, ArrayList.class, new String[0])));
                productLevel.setExternalIdentifier(item.getId());
                productLevel.setId(null);
                return productLevel;
            }).collect(Collectors.toList());
            this.productLevelService.saveBatch(target);
        }
    }

    private void bulidMaterial(List<MaterialMdmVo> materialMdmVos) {
        if (!CollectionUtils.isEmpty(materialMdmVos)) {
            List<Material> target = materialMdmVos.stream().map(item -> {
                Material material = new Material();
                BeanUtils.copyProperties((Object)item, (Object)((Object)material), (String[])new String[]{"costPrice"});
                if (StringUtils.isNotBlank((CharSequence)item.getCostPrice())) {
                    material.setCostPrice(new BigDecimal(item.getCostPrice()));
                }
                material.setExternalIdentifier(item.getId());
                material.setId(null);
                return material;
            }).collect(Collectors.toList());
            this.saveBatch(target);
        }
    }

    private void bulidMaterialMedia(List<MaterialMediaMdmVo> mediaMdmVos) {
        List<MaterialMedia> target;
        if (!CollectionUtils.isEmpty(mediaMdmVos) && !CollectionUtils.isEmpty(target = mediaMdmVos.stream().map(item -> {
            MaterialMedia media = new MaterialMedia();
            BeanUtils.copyProperties((Object)item, (Object)((Object)media));
            media.setExternalIdentifier(item.getId());
            media.setId(null);
            return media;
        }).collect(Collectors.toList()))) {
            this.materialMediaService.createBatch(target);
        }
    }

    private void createValidation(Material material) {
        Validate.notNull((Object)((Object)material), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        material.setId(null);
        Validate.notBlank((CharSequence)material.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)material.getProductLevelCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)material.getMaterialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((material.getMaterialName().length() < 128 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getAiCode() == null || material.getAiCode().length() < 128 ? 1 : 0) != 0, (String)"ai\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getBarCode() == null || material.getBarCode().length() < 128 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getBaseUnit() == null || material.getBaseUnit().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u672c\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSaleCompany() == null || material.getSaleCompany().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u516c\u53f8\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSaleUnit() == null || material.getSaleUnit().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSpecification() == null || material.getSpecification().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getUnitConversion() == null || material.getUnitConversion().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getGrossWeight() == null || material.getGrossWeight().length() < 64 ? 1 : 0) != 0, (String)"\u6bdb\u91cd\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getNetWeight() == null || material.getNetWeight().length() < 64 ? 1 : 0) != 0, (String)"\u51c0\u91cd\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getCapacity() == null || material.getCapacity().length() < 64 ? 1 : 0) != 0, (String)"\u5bb9\u91cf\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)material.getProductLevelCode())) {
            ProductLevel productLevel = this.productLevelService.findByProductLevelCode(material.getProductLevelCode());
            Validate.notNull((Object)((Object)productLevel), (String)("\u5546\u54c1\u5c42\u7ea7\u7f16\u7801[" + material.getProductLevelCode() + "]\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)material.getMaterialCode())) {
            List list = ((LambdaQueryChainWrapper)this.materialRepository.lambdaQuery().eq(Material::getMaterialCode, (Object)material.getMaterialCode())).select(new SFunction[]{UuidEntity::getId}).list();
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)("\u7f16\u7801[" + material.getMaterialCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private void updateValidation(Material material) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)material.getId()) || !StringUtils.isBlank((CharSequence)material.getMaterialCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e/\u7f16\u7801\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.isTrue((material.getMaterialName().length() < 128 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getAiCode() == null || material.getAiCode().length() < 64 ? 1 : 0) != 0, (String)"ai\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getBarCode() == null || material.getBarCode().length() < 64 ? 1 : 0) != 0, (String)"\u6761\u5f62\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getBaseUnit() == null || material.getBaseUnit().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u672c\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSaleCompany() == null || material.getSaleCompany().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u516c\u53f8\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSaleUnit() == null || material.getSaleUnit().length() < 64 ? 1 : 0) != 0, (String)"\u9500\u552e\u5355\u4f4d\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getSpecification() == null || material.getSpecification().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getUnitConversion() == null || material.getUnitConversion().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getGrossWeight() == null || material.getGrossWeight().length() < 64 ? 1 : 0) != 0, (String)"\u6bdb\u91cd\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getNetWeight() == null || material.getNetWeight().length() < 64 ? 1 : 0) != 0, (String)"\u51c0\u91cd\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((material.getCapacity() == null || material.getCapacity().length() < 64 ? 1 : 0) != 0, (String)"\u5bb9\u91cf\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)material.getProductLevelCode())) {
            ProductLevel productLevel = this.productLevelService.findByProductLevelCode(material.getProductLevelCode());
            Validate.notNull((Object)((Object)productLevel), (String)("\u5546\u54c1\u5c42\u7ea7\u7f16\u7801[" + material.getProductLevelCode() + "]\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

