/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialStandardUnitTypeEnum;
import com.biz.crm.cps.business.product.sdk.dto.MaterialStandardUnitDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="MaterialStandardUnitVoServiceImpl")
public class MaterialStandardUnitVoServiceImpl
implements MaterialStandardUnitVoService {
    @Autowired
    private MaterialService materialService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BarCodeVoService barCodeVoService;

    public List<MaterialStandardUnitVo> findAll() {
        List<Material> materials = this.materialService.findAll();
        if (CollectionUtils.isEmpty(materials)) {
            return null;
        }
        List<MaterialStandardUnitVo> standardUnitVos = materials.stream().map(item -> {
            MaterialStandardUnitVo vo = new MaterialStandardUnitVo();
            vo.setMaterialName(item.getMaterialName());
            vo.setStandardUnitDesc(this.buildStandardUnitDesc((Material)((Object)item)));
            return vo;
        }).filter(item -> !CollectionUtils.isEmpty((Collection)item.getStandardUnitDesc())).collect(Collectors.toList());
        return standardUnitVos;
    }

    public List<MaterialStandardUnitVo> findByMaterialCodeAndBarCodeType(List<MaterialStandardUnitDto> materialStandardUnitDtos) {
        if (CollectionUtils.isEmpty(materialStandardUnitDtos)) {
            return null;
        }
        HashMap<String, String> relMap = new HashMap<String, String>();
        for (MaterialStandardUnitDto materialStandardUnitDto : materialStandardUnitDtos) {
            relMap.put(materialStandardUnitDto.getMaterialCode(), materialStandardUnitDto.getBarCodeType());
        }
        List<String> materialCodes = materialStandardUnitDtos.stream().map(MaterialStandardUnitDto::getMaterialCode).collect(Collectors.toList());
        List<Material> materials = this.materialService.findByMaterialCodes(materialCodes);
        if (CollectionUtils.isEmpty(materials)) {
            return null;
        }
        ArrayList vos = Lists.newArrayList();
        for (Material material : materials) {
            MaterialStandardUnitVo vo = (MaterialStandardUnitVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)material, MaterialStandardUnitVo.class, HashSet.class, ArrayList.class, new String[0]);
            String barCodeType = (String)relMap.get(material.getMaterialCode());
            this.buildStandardUnit(vo, material, barCodeType);
            vos.add(vo);
        }
        return vos;
    }

    public List<MaterialStandardUnitVo> findByBarCodeAndBarCodeType(List<MaterialStandardUnitDto> materialStandardUnitDtos) {
        if (CollectionUtils.isEmpty(materialStandardUnitDtos)) {
            return null;
        }
        List<String> materialCodes = materialStandardUnitDtos.stream().map(MaterialStandardUnitDto::getMaterialCode).distinct().collect(Collectors.toList());
        List<Material> materials = this.materialService.findByMaterialCodes(materialCodes);
        if (CollectionUtils.isEmpty(materials)) {
            return null;
        }
        ArrayList vos = Lists.newArrayList();
        for (MaterialStandardUnitDto dto : materialStandardUnitDtos) {
            MaterialStandardUnitVo vo = new MaterialStandardUnitVo();
            vo.setBarCode(dto.getBarCode());
            vo.setMaterialCode(dto.getMaterialCode());
            vo.setBarCodeType(dto.getBarCodeType());
            Material material = materials.stream().filter(item -> Objects.equals(item.getMaterialCode(), dto.getMaterialCode())).findFirst().orElse(null);
            if (Objects.nonNull((Object)material)) {
                this.buildStandardUnit(vo, material, dto.getBarCodeType());
            }
            vos.add(vo);
        }
        return vos;
    }

    public MaterialStandardUnitVo findByBarCodes(List<String> barCodes) {
        if (CollectionUtils.isEmpty(barCodes)) {
            return null;
        }
        List barCodeVos = this.barCodeVoService.findByBarCodes(barCodes);
        if (CollectionUtils.isEmpty((Collection)barCodeVos)) {
            return null;
        }
        List<MaterialStandardUnitDto> materialStandardUnitDtos = barCodeVos.stream().map(item -> {
            MaterialStandardUnitDto vo = new MaterialStandardUnitDto();
            vo.setMaterialCode(item.getProductCode());
            vo.setBarCodeType(item.getBarCodeType());
            vo.setBarCode(item.getBarCode());
            return vo;
        }).collect(Collectors.toList());
        List<MaterialStandardUnitVo> vos = this.findByBarCodeAndBarCodeType(materialStandardUnitDtos);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        Map<String, List<MaterialStandardUnitVo>> relMap = vos.stream().filter(item -> Objects.nonNull(item.getStandardUnitTypeDesc())).collect(Collectors.groupingBy(MaterialStandardUnitVo::getStandardUnitTypeDesc));
        ArrayList units = Lists.newArrayList();
        for (Map.Entry<String, List<MaterialStandardUnitVo>> entry : relMap.entrySet()) {
            List<MaterialStandardUnitVo> unitVos = entry.getValue();
            BigDecimal value = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(vos)) {
                value = unitVos.stream().map(MaterialStandardUnitVo::getStandardUnitValue).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            }
            units.add(value.toString() + entry.getKey());
        }
        MaterialStandardUnitVo vo = new MaterialStandardUnitVo();
        if (!CollectionUtils.isEmpty((Collection)units)) {
            Object[] unitArr = new String[units.size()];
            units.toArray(unitArr);
            String unit = StringUtils.joinWith(null, (Object[])unitArr);
            vo.setStandardUnit(unit);
        }
        return vo;
    }

    private void buildStandardUnit(MaterialStandardUnitVo vo, Material material, String barCodeType) {
        if (StringUtils.isBlank((CharSequence)material.getStandardUnit())) {
            return;
        }
        String unit = "~";
        MaterialStandardUnitTypeEnum standardUnitEnum = MaterialStandardUnitTypeEnum.getByKey((String)material.getStandardUnit());
        String standardUnit = Objects.isNull(standardUnitEnum) ? "" : standardUnitEnum.getValue();
        BigDecimal boxUnitConversion = material.getBoxUnitConversion();
        BigDecimal caseUnitConversion = material.getCaseUnitConversion();
        if (Objects.isNull(boxUnitConversion) || Objects.isNull(caseUnitConversion)) {
            return;
        }
        if (Objects.equals(barCodeType, BarCodeTypeEnum.BOTTLE.getFlag())) {
            vo.setStandardUnitValue(boxUnitConversion);
            unit = boxUnitConversion.toString() + standardUnit;
        } else if (Objects.equals(barCodeType, BarCodeTypeEnum.BOX.getFlag())) {
            vo.setStandardUnitValue(caseUnitConversion);
            unit = caseUnitConversion.toString() + standardUnit;
        }
        vo.setStandardUnitType(standardUnitEnum.getDictCode());
        vo.setStandardUnitTypeDesc(standardUnitEnum.getValue());
        vo.setStandardUnit(unit);
    }

    private List<String> buildStandardUnitDesc(Material material) {
        Object unit = null;
        MaterialStandardUnitTypeEnum standardUnitEnum = MaterialStandardUnitTypeEnum.getByKey((String)material.getStandardUnit());
        String standardUnit = Objects.isNull(standardUnitEnum) ? "" : standardUnitEnum.getValue();
        BigDecimal boxUnitConversion = material.getBoxUnitConversion();
        BigDecimal caseUnitConversion = material.getCaseUnitConversion();
        ArrayList conversions = Lists.newArrayList();
        if (Objects.nonNull(boxUnitConversion)) {
            conversions.add("1\u81ea\u7136\u76d2\u7b49\u4e8e" + boxUnitConversion.toString() + standardUnit);
        }
        if (Objects.nonNull(caseUnitConversion)) {
            conversions.add("1\u81ea\u7136\u7bb1\u7b49\u4e8e" + caseUnitConversion.toString() + standardUnit);
        }
        return conversions;
    }
}

