/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.repository.ProductLevelRepository;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductLevelTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProductLevelServiceImpl
implements ProductLevelService {
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private ProductLevelRepository productLevelRepository;

    @Override
    @Transactional
    public ProductLevel create(ProductLevel productLevel) {
        ProductLevel current = this.createForm(productLevel);
        this.productLevelRepository.save((Object)current);
        return current;
    }

    @Override
    public ProductLevel createForm(ProductLevel productLevel) {
        String productLevelCode;
        Date now = new Date();
        String account = this.getLoginAccountName();
        productLevel.setTenantCode(TenantUtils.getTenantCode());
        productLevel.setCreateAccount(account);
        productLevel.setCreateTime(now);
        productLevel.setModifyAccount(account);
        productLevel.setModifyTime(now);
        this.createValidation(productLevel);
        if (StringUtils.isBlank((CharSequence)productLevel.getDelFlag())) {
            productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)productLevel.getEnableStatus())) {
            productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isBlank((CharSequence)(productLevelCode = productLevel.getProductLevelCode()))) {
            productLevelCode = (String)this.generateCodeService.generateCode("productLevel", 1).get(0);
            productLevel.setProductLevelCode(productLevelCode);
        }
        String parentCode = productLevel.getParentCode();
        String ruleCode = "";
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            ProductLevel parent = this.findByProductLevelCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5546\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            ruleCode = parent.getRuleCode() + productLevelCode + "|";
        } else {
            ruleCode = productLevelCode + "|";
        }
        productLevel.setRuleCode(ruleCode);
        return productLevel;
    }

    @Override
    @Transactional
    public ProductLevel update(ProductLevel productLevel) {
        ProductLevel current = this.updateForm(productLevel);
        return current;
    }

    @Override
    public ProductLevel updateForm(ProductLevel productLevel) {
        this.updateValidation(productLevel);
        String currentId = productLevel.getId();
        String productLevelCode = productLevel.getProductLevelCode();
        ProductLevel current = null;
        if (StringUtils.isNotBlank((CharSequence)currentId)) {
            current = (ProductLevel)((Object)this.productLevelRepository.getById((Serializable)((Object)currentId)));
        } else if (StringUtils.isNotBlank((CharSequence)productLevelCode)) {
            current = this.findByProductLevelCode(productLevelCode);
        }
        current = (ProductLevel)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        BeanUtils.copyProperties((Object)((Object)productLevel), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode", "ruleCode"});
        Date now = new Date();
        String account = this.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.productLevelRepository.saveOrUpdate((Object)current);
        return current;
    }

    @Override
    public ProductLevel findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ProductLevel)((Object)this.productLevelRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public ProductLevel findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.productLevelRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.productLevelRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        this.productLevelRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public List<ProductLevel> createBatch(List<ProductLevel> productLevels) {
        if (!CollectionUtils.isEmpty(productLevels)) {
            for (ProductLevel productLevel : productLevels) {
                this.createForm(productLevel);
            }
            this.productLevelRepository.saveBatch(productLevels);
            return productLevels;
        }
        return Lists.newArrayList();
    }

    private List<ProductLevel> updateBatch(List<ProductLevel> productLevels) {
        if (!CollectionUtils.isEmpty(productLevels)) {
            for (ProductLevel productLevel : productLevels) {
                this.updateForm(productLevel);
            }
            return productLevels;
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public void saveBatch(List<ProductLevel> target) {
        if (!CollectionUtils.isEmpty(target)) {
            Arrays.stream(ProductLevelTypeEnum.values()).forEach(item -> {
                List tempTarget = target.stream().filter(targetItem -> Objects.equals(targetItem.getProductLevelType(), item.getKey())).collect(Collectors.toList());
                List<String> productLevelCodes = tempTarget.stream().map(ProductLevel::getProductLevelCode).distinct().collect(Collectors.toList());
                List<Object> oldList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(productLevelCodes)) {
                    oldList = this.productLevelRepository.findByProductLevelCodes(productLevelCodes);
                }
                ArrayList addList = Lists.newArrayList();
                ArrayList needUpdateList = Lists.newArrayList();
                ArrayList delList = Lists.newArrayList();
                this.nebulaToolkitService.collectionDiscrepancy(tempTarget, (Collection)oldList, ProductLevel::getProductLevelCode, (Collection)delList, (Collection)needUpdateList, (Collection)addList);
                this.createBatch(addList);
                if (!CollectionUtils.isEmpty((Collection)needUpdateList)) {
                    List needUpdateCodeList = needUpdateList.stream().map(ProductLevel::getProductLevelCode).collect(Collectors.toList());
                    List<ProductLevel> updateList = target.stream().filter(pitem -> needUpdateCodeList.contains(pitem.getProductLevelCode())).collect(Collectors.toList());
                    this.updateBatch(updateList);
                }
            });
        }
    }

    @Override
    public ProductLevel findByProductLevelCode(String productLevelCode) {
        if (StringUtils.isBlank((CharSequence)productLevelCode)) {
            return null;
        }
        return this.productLevelRepository.findByProductLevelCode(productLevelCode);
    }

    @Override
    public ProductLevel findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return null;
        }
        return this.productLevelRepository.findByParentCode(parentCode);
    }

    @Override
    public List<ProductLevel> findAllParentsByProductLevelCode(String productLevelCode) {
        if (StringUtils.isBlank((CharSequence)productLevelCode)) {
            return Lists.newArrayList();
        }
        return this.productLevelRepository.findAllParentsByProductLevelCode(productLevelCode);
    }

    @Override
    public List<ProductLevel> findByProductLevelCodes(List<String> productLevelCodes) {
        if (CollectionUtils.isEmpty(productLevelCodes)) {
            return null;
        }
        return this.productLevelRepository.findByProductLevelCodes(productLevelCodes);
    }

    private void createValidation(ProductLevel productLevel) {
        Validate.notNull((Object)((Object)productLevel), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        productLevel.setId(null);
        Validate.notBlank((CharSequence)productLevel.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getProductLevelName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getProductLevelType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getRuleCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7ruleCode\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ProductLevelTypeEnum.getByKey((String)productLevel.getProductLevelType()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((productLevel.getProductLevelName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)productLevel.getProductLevelCode())) {
            List list = ((LambdaQueryChainWrapper)this.productLevelRepository.lambdaQuery().eq(ProductLevel::getProductLevelCode, (Object)productLevel.getProductLevelCode())).select(new SFunction[]{UuidEntity::getId}).list();
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)("\u7f16\u7801[" + productLevel.getProductLevelCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
    }

    private void updateValidation(ProductLevel productLevel) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)productLevel.getId()) || !StringUtils.isBlank((CharSequence)productLevel.getProductLevelCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e/\u7f16\u7801\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getProductLevelName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getProductLevelType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productLevel.getRuleCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7ruleCode\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)ProductLevelTypeEnum.getByKey((String)productLevel.getProductLevelType()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((productLevel.getProductLevelName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\u5c42\u7ea7\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

