/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.local.vo.MaterialGroupInfoVo;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.mapper.MaterialGroupRelMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialGroupRelRepository
extends ServiceImpl<MaterialGroupRelMapper, MaterialGroupRel> {
    public MaterialGroupRel findDetailsById(String id) {
        return ((MaterialGroupRelMapper)this.baseMapper).findDetailsById(id);
    }

    public List<MaterialGroupRel> findByMaterialGroupCode(String materialGroupCode) {
        return ((MaterialGroupRelMapper)this.baseMapper).findByMaterialGroupCode(materialGroupCode);
    }

    public List<MaterialGroupRel> findByMaterialCode(String materialCode) {
        return ((MaterialGroupRelMapper)this.baseMapper).findByMaterialCode(materialCode);
    }

    public void deleteByMaterialGroupCode(String materialGroupCode) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MaterialGroupRel::getMaterialGroupCode, (Object)materialGroupCode)).remove();
    }

    public List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MaterialGroupRel::getMaterialGroupCode, materialGroupCodes)).list();
    }

    public List<MaterialGroupInfoVo> findInfoListByMaterialGroupCodeList(List<String> materialGroupCodeList) {
        if (CollectionUtils.isEmpty(materialGroupCodeList)) {
            return new ArrayList<MaterialGroupInfoVo>();
        }
        return ((MaterialGroupRelMapper)this.baseMapper).findInfoListByMaterialGroupCodeList(materialGroupCodeList);
    }
}

