/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.common.local.vo.MaterialGroupInfoVo;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.repository.MaterialGroupRelRepository;
import com.biz.crm.cps.business.product.local.service.MaterialGroupRelService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialGroupRelServiceImpl
implements MaterialGroupRelService {
    @Autowired
    private MaterialGroupRelRepository materialGroupRelRepository;

    @Override
    @Transactional
    public MaterialGroupRel create(MaterialGroupRel materialGroupRel) {
        MaterialGroupRel current = this.createForm(materialGroupRel);
        this.materialGroupRelRepository.save((Object)current);
        return current;
    }

    @Override
    @Transactional
    public void createBatch(List<MaterialGroupRel> materialGroupRels) {
        Validate.notEmpty(materialGroupRels, (String)"\u7269\u6599\u7ec4\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<MaterialGroupRel>> materialMediaMap = materialGroupRels.stream().collect(Collectors.groupingBy(MaterialGroupRel::getMaterialGroupCode));
        for (Map.Entry<String, List<MaterialGroupRel>> entry : materialMediaMap.entrySet()) {
            String materialGroupCode = entry.getKey();
            List<MaterialGroupRel> tempMaterialRels = entry.getValue();
            List<MaterialGroupRel> old = this.materialGroupRelRepository.findByMaterialGroupCode(materialGroupCode);
            if (!CollectionUtils.isEmpty(old)) {
                this.materialGroupRelRepository.deleteByMaterialGroupCode(materialGroupCode);
            }
            for (MaterialGroupRel materialGroup : tempMaterialRels) {
                this.createForm(materialGroup);
            }
            this.materialGroupRelRepository.saveBatch(tempMaterialRels);
        }
    }

    private MaterialGroupRel createForm(MaterialGroupRel materialGroupRel) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        materialGroupRel.setCreateAccount(account);
        materialGroupRel.setCreateTime(now);
        materialGroupRel.setModifyAccount(account);
        materialGroupRel.setModifyTime(now);
        this.createValidation(materialGroupRel);
        this.createValidation(materialGroupRel);
        if (StringUtils.isBlank((CharSequence)materialGroupRel.getDelFlag())) {
            materialGroupRel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)materialGroupRel.getEnableStatus())) {
            materialGroupRel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        return materialGroupRel;
    }

    @Override
    public MaterialGroupRel findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (MaterialGroupRel)((Object)this.materialGroupRelRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public MaterialGroupRel findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialGroupRelRepository.findDetailsById(id);
    }

    @Override
    public List<MaterialGroupRel> findByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        return this.materialGroupRelRepository.findByMaterialCode(materialCode);
    }

    @Override
    public List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes) {
        Validate.notEmpty(materialGroupCodes, (String)"\u7269\u6599\u7ec4\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.materialGroupRelRepository.findByMaterialGroupCodes(materialGroupCodes);
    }

    @Override
    public List<MaterialGroupInfoVo> findInfoListByMaterialGroupCodeList(List<String> materialGroupCodeList) {
        return this.materialGroupRelRepository.findInfoListByMaterialGroupCodeList(materialGroupCodeList);
    }

    private void createValidation(MaterialGroupRel materialGroupRel) {
        Validate.notNull((Object)((Object)materialGroupRel), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        materialGroupRel.setId(null);
        Validate.notNull((Object)materialGroupRel.getMaterialGroupCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)materialGroupRel.getMaterialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

