/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.service.MaterialGroupRelService;
import com.biz.crm.cps.business.product.local.service.MaterialGroupService;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialDimensionEnum;
import com.biz.crm.cps.business.product.sdk.dto.MaterialDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.MaterialGroupRelDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.business.product.sdk.vo.MaterialGroupRelVo;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductLevelVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductMaterialVo;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialVoServiceImpl
implements MaterialVoService {
    private static final Logger log = LoggerFactory.getLogger(MaterialVoServiceImpl.class);
    @Autowired
    private MaterialService materialService;
    @Autowired
    private ProductLevelService productLevelService;
    @Autowired
    private ProductMaterialService productMaterialService;
    @Autowired
    private MaterialGroupRelService materialGroupRelService;
    @Autowired
    private MaterialGroupService materialGroupService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public MaterialDimensionVo findByMaterialCode(String materialCode) {
        List<MaterialGroupRel> rels;
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        Material material = this.materialService.findByMaterialCode(materialCode);
        if (Objects.isNull((Object)material)) {
            this.sync(materialCode);
            material = this.materialService.findByMaterialCode(materialCode);
            if (Objects.isNull((Object)material)) {
                return null;
            }
        }
        MaterialDimensionVo vo = (MaterialDimensionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)material, MaterialDimensionVo.class, Set.class, ArrayList.class, new String[0]);
        List<ProductMaterial> productMaterials = this.productMaterialService.findByMaterialCode(materialCode);
        vo.setProductMaterials((Set)Sets.newHashSet());
        if (!CollectionUtils.isEmpty(productMaterials)) {
            List productMaterialVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productMaterials, ProductMaterial.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setProductMaterials((Set)Sets.newHashSet((Iterable)productMaterialVos));
        } else {
            vo.setProductMaterials((Set)Sets.newHashSet());
        }
        if (StringUtils.isNotBlank((CharSequence)material.getProductLevelCode())) {
            List<ProductLevel> productLevelList = this.productLevelService.findAllParentsByProductLevelCode(material.getProductLevelCode());
            if (!CollectionUtils.isEmpty(productLevelList)) {
                List productLevelVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productLevelList, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
                vo.setProductLevels((Set)Sets.newHashSet((Iterable)productLevelVos));
            } else {
                vo.setProductLevels((Set)Sets.newHashSet());
            }
        }
        if (!CollectionUtils.isEmpty(rels = this.materialGroupRelService.findByMaterialCode(materialCode))) {
            List relVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(rels, MaterialGroupRel.class, MaterialGroupRelVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setMaterialGroupRels((Set)Sets.newHashSet((Iterable)relVos));
        } else {
            vo.setMaterialGroupRels((Set)Sets.newHashSet());
        }
        return vo;
    }

    public List<String> findDimensionCodes(MaterialDimensionDto materialDimensionDto, String dimensionType) {
        if (!Objects.isNull(materialDimensionDto)) {
            if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL.getDictCode())) {
                return Lists.newArrayList((Object[])new String[]{materialDimensionDto.getMaterialCode()});
            }
            if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL_GROUP.getDictCode())) {
                Set rels = materialDimensionDto.getMaterialGroupRels();
                if (!CollectionUtils.isEmpty((Collection)rels)) {
                    return rels.stream().map(MaterialGroupRelDto::getMaterialGroupCode).collect(Collectors.toList());
                }
            } else {
                ProductLevelDto levelDto;
                if (Objects.equals(dimensionType, MaterialDimensionEnum.ALL.getDictCode())) {
                    return Lists.newArrayList((Object[])new String[]{"DIMENSION_ALL"});
                }
                Set levelDtos = materialDimensionDto.getProductLevels();
                if (!CollectionUtils.isEmpty((Collection)levelDtos) && (levelDto = (ProductLevelDto)levelDtos.stream().filter(item -> Objects.equals(item.getProductLevelType(), dimensionType)).findFirst().orElse(null)) != null) {
                    return Lists.newArrayList((Object[])new String[]{levelDto.getProductLevelCode()});
                }
            }
        }
        return null;
    }

    public List<String> findMaterialCodeByDimensionCodesAndDimensionType(List<String> dimensionCodes, String dimensionType) {
        if (StringUtils.isNotBlank((CharSequence)dimensionType) && !CollectionUtils.isEmpty(dimensionCodes)) {
            if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL.getDictCode())) {
                List<Material> materials = this.materialService.findByMaterialCodes(dimensionCodes);
                if (!CollectionUtils.isEmpty(materials)) {
                    return materials.stream().map(Material::getMaterialCode).collect(Collectors.toList());
                }
            } else if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL_GROUP.getDictCode())) {
                List<MaterialGroupRel> rels = this.materialGroupRelService.findByMaterialGroupCodes(dimensionCodes);
                if (!CollectionUtils.isEmpty(rels)) {
                    return rels.stream().map(MaterialGroupRel::getMaterialCode).collect(Collectors.toList());
                }
            } else {
                if (Objects.equals(dimensionType, MaterialDimensionEnum.ALL.getDictCode())) {
                    return Lists.newArrayList((Object[])new String[]{"DIMENSION_ALL"});
                }
                List<Material> materials = this.materialService.findAllChildrenByProductLevelCodes(dimensionCodes);
                if (!CollectionUtils.isEmpty(materials)) {
                    return materials.stream().map(Material::getMaterialCode).collect(Collectors.toList());
                }
            }
        }
        return null;
    }

    public List<MaterialVo> findByMaterialCode(List<String> materialCodes) {
        if (CollectionUtils.isEmpty(materialCodes)) {
            return null;
        }
        List<Material> materials = this.materialService.findByMaterialCodes(materialCodes);
        if (!CollectionUtils.isEmpty(materials)) {
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList(materials, Material.class, MaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    public void sync(List<String> dimensionCodes, String dimensionType) {
        if (StringUtils.isNotBlank((CharSequence)dimensionType) && !CollectionUtils.isEmpty(dimensionCodes)) {
            try {
                if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL.getDictCode())) {
                    MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
                    dto.setMaterialCodes(dimensionCodes);
                    PageRequest pageable = PageRequest.of((int)1, (int)1000);
                    this.materialService.sync((Pageable)pageable, dto);
                } else if (Objects.equals(dimensionType, MaterialDimensionEnum.MATERIAL_GROUP.getDictCode())) {
                    PageRequest pageable = PageRequest.of((int)1, (int)1000);
                    MaterialGroupMdmPaginationDto dto = new MaterialGroupMdmPaginationDto();
                    dto.setMaterialGroupCodes(dimensionCodes);
                    this.materialGroupService.sync((Pageable)pageable, dto);
                } else if (Objects.equals(dimensionType, MaterialDimensionEnum.ALL.getDictCode())) {
                    MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
                    PageRequest pageable = PageRequest.of((int)1, (int)1000);
                    this.materialService.sync((Pageable)pageable, dto);
                } else {
                    MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
                    dto.setProductLevelCodes(dimensionCodes);
                    PageRequest pageable = PageRequest.of((int)1, (int)1000);
                    this.materialService.sync((Pageable)pageable, dto);
                }
            }
            catch (RuntimeException e) {
                log.error("\u540c\u6b65\u7269\u6599\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sync(String materialCode) {
        try {
            MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
            dto.setMaterialCode(materialCode);
            PageRequest pageable = PageRequest.of((int)1, (int)1000);
            this.materialService.sync((Pageable)pageable, dto);
            PageRequest pageableGroup = PageRequest.of((int)1, (int)1000);
            MaterialGroupMdmPaginationDto groupDto = new MaterialGroupMdmPaginationDto();
            dto.setMaterialCode(materialCode);
            this.materialGroupService.sync((Pageable)pageableGroup, groupDto);
        }
        catch (RuntimeException e) {
            log.error("\u540c\u6b65\u7269\u6599\u3010" + materialCode + "\u3011\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
    }
}

