/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.Product;
import com.biz.crm.cps.business.product.local.mapper.ProductMapper;
import com.biz.crm.cps.business.product.sdk.dto.ProductPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductRepository
extends ServiceImpl<ProductMapper, Product> {
    public Product findDetailsById(String id) {
        return ((ProductMapper)this.baseMapper).findDetailsById(id);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Product findByProductCode(String productCode) {
        return ((ProductMapper)this.baseMapper).findByProductCode(productCode);
    }

    public List<Product> findByProductLevelCode(String productLevelCode) {
        return ((ProductMapper)this.baseMapper).findByProductLevelCode(productLevelCode);
    }

    public List<Product> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty(ids), BaseIdEntity::getId, ids)).list();
    }

    public List<Product> findByProductCodes(List<String> productCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Product::getProductCode, productCodes)).list();
    }

    public Page<Product> findByConditions(Pageable pageable, ProductPaginationDto productPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductMapper)this.baseMapper).findByConditions((Page<Product>)page, productPaginationDto);
    }
}

