/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.MaterialGroup;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.repository.MaterialGroupRepository;
import com.biz.crm.cps.business.product.local.service.MaterialGroupRelService;
import com.biz.crm.cps.business.product.local.service.MaterialGroupService;
import com.biz.crm.cps.business.product.local.service.MaterialService;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialGroupServiceImpl
implements MaterialGroupService {
    private static final Logger log = LoggerFactory.getLogger(MaterialGroupServiceImpl.class);
    @Autowired
    private MaterialGroupRepository materialGroupRepository;
    @Autowired(required=false)
    private MaterialMdmService materialMdmService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private MaterialGroupRelService materialGroupRelService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public MaterialGroup create(MaterialGroup materialGroup) {
        MaterialGroup current = this.createForm(materialGroup);
        this.materialGroupRepository.save((Object)current);
        return current;
    }

    private MaterialGroup createForm(MaterialGroup materialGroup) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        materialGroup.setTenantCode(TenantUtils.getTenantCode());
        materialGroup.setCreateAccount(account);
        materialGroup.setCreateTime(now);
        materialGroup.setModifyAccount(account);
        materialGroup.setModifyTime(now);
        this.createValidation(materialGroup);
        if (StringUtils.isBlank((CharSequence)materialGroup.getDelFlag())) {
            materialGroup.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)materialGroup.getEnableStatus())) {
            materialGroup.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        return materialGroup;
    }

    @Override
    @Transactional
    public MaterialGroup update(MaterialGroup materialGroup) {
        MaterialGroup current = this.updateForm(materialGroup);
        return current;
    }

    private MaterialGroup updateForm(MaterialGroup materialGroup) {
        this.updateValidation(materialGroup);
        String currentId = materialGroup.getId();
        String materialGroupCode = materialGroup.getMaterialGroupCode();
        MaterialGroup current = null;
        if (StringUtils.isNotBlank((CharSequence)currentId)) {
            current = (MaterialGroup)((Object)this.materialGroupRepository.getById((Serializable)((Object)currentId)));
        } else if (StringUtils.isNotBlank((CharSequence)materialGroupCode)) {
            current = this.findByMaterialGroupCode(materialGroupCode);
        }
        current = (MaterialGroup)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        BeanUtils.copyProperties((Object)((Object)materialGroup), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.getLoginAccountName();
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.materialGroupRepository.saveOrUpdate((Object)current);
        return current;
    }

    @Override
    public MaterialGroup findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (MaterialGroup)((Object)this.materialGroupRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public MaterialGroup findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialGroupRepository.findDetailsById(id);
    }

    @Override
    public MaterialGroup findByMaterialGroupCode(String materialGroupCode) {
        if (StringUtils.isBlank((CharSequence)materialGroupCode)) {
            return null;
        }
        return this.materialGroupRepository.findByMaterialGroupCode(materialGroupCode);
    }

    @Override
    @Transactional
    public void sync(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto) {
        boolean isQuery = true;
        int pageNumber = pageable.getPageNumber() - 1;
        while (isQuery) {
            int pageSize = pageable.getPageSize();
            PageRequest pageRequest = PageRequest.of((int)(++pageNumber), (int)pageSize);
            Page page = this.materialMdmService.findByConditions((Pageable)pageRequest, materialGroupMdmPaginationDto);
            this.syncDataHandle(page.getRecords());
            if (page.getRecords().size() >= pageSize) continue;
            isQuery = false;
        }
    }

    private void syncDataHandle(List<MaterialGroupMdmVo> materialGroupMdmVos) {
        if (CollectionUtils.isEmpty(materialGroupMdmVos)) {
            log.info("\u540c\u6b65\u7269\u6599\u7ec4\u65f6\uff1a\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
            return;
        }
        List materialMdmVos = materialGroupMdmVos.stream().flatMap(item -> item.getMaterialMdmVos().stream()).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MaterialMdmVo>(Comparator.comparing(MaterialMdmVo::getId))), ArrayList::new));
        this.materialService.syncDataHandle(materialMdmVos);
        for (MaterialGroupMdmVo materialGroupMdmVo : materialGroupMdmVos) {
            List materialMdmVoList = materialGroupMdmVo.getMaterialMdmVos();
            MaterialGroup materialGroup = (MaterialGroup)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)materialGroupMdmVo, MaterialGroup.class, HashSet.class, ArrayList.class, new String[0]));
            materialGroup.setExternalIdentifier(materialGroupMdmVo.getId());
            materialGroup.setId(null);
            MaterialGroup old = this.findByMaterialGroupCode(materialGroupMdmVo.getMaterialGroupCode());
            MaterialGroup materialGroupResult = null;
            if (old == null) {
                materialGroupResult = this.create(materialGroup);
            } else {
                BeanUtils.copyProperties((Object)((Object)materialGroup), (Object)((Object)old), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
                materialGroupResult = this.update(old);
            }
            if (materialGroupResult == null) continue;
            MaterialGroup finalMaterialGroupResult = materialGroupResult;
            List<MaterialGroupRel> materialGroupRels = materialMdmVoList.stream().map(item -> {
                MaterialGroupRel rel = new MaterialGroupRel();
                rel.setMaterialCode(item.getMaterialCode());
                rel.setMaterialGroupCode(finalMaterialGroupResult.getMaterialGroupCode());
                return rel;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(materialGroupRels)) continue;
            this.materialGroupRelService.createBatch(materialGroupRels);
        }
    }

    private void updateValidation(MaterialGroup materialGroup) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)materialGroup.getId()) || !StringUtils.isBlank((CharSequence)materialGroup.getMaterialGroupCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e/\u7f16\u7801\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)materialGroup.getMaterialGroupName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)materialGroup.getMaterialNum(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((materialGroup.getMaterialNum().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.isTrue((materialGroup.getDescription() == null || materialGroup.getDescription().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6599\u7ec4\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createValidation(MaterialGroup materialGroup) {
        Validate.notNull((Object)((Object)materialGroup), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        materialGroup.setId(null);
        Validate.notNull((Object)materialGroup.getMaterialGroupName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)materialGroup.getMaterialNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((materialGroup.getMaterialNum().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.isTrue((materialGroup.getDescription() == null || materialGroup.getDescription().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6599\u7ec4\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

