/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.mapper.ProductLevelMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductLevelRepository
extends ServiceImpl<ProductLevelMapper, ProductLevel> {
    public ProductLevel findDetailsById(String id) {
        return ((ProductLevelMapper)this.baseMapper).findDetailsById(id);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public ProductLevel findByProductLevelCode(String productLevelCode) {
        return ((ProductLevelMapper)this.baseMapper).findByProductLevelCode(productLevelCode);
    }

    public ProductLevel findByParentCode(String parentCode) {
        return ((ProductLevelMapper)this.baseMapper).findByParentCode(parentCode);
    }

    public List<ProductLevel> findAllParentsByProductLevelCode(String productLevelCode) {
        ArrayList<ProductLevel> list = new ArrayList<ProductLevel>();
        ProductLevel one = (ProductLevel)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)productLevelCode), ProductLevel::getProductLevelCode, (Object)productLevelCode)).one());
        if (one != null) {
            Set<String> ruleCodes = this.splitParentRuleCodes(one.getRuleCode(), "|");
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductLevel::getRuleCode, ruleCodes)).list();
            list.addAll(entityList);
        }
        return list;
    }

    public List<ProductLevel> findByProductLevelCodes(List<String> productLevelCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductLevel::getProductLevelCode, productLevelCodes)).list();
    }

    private Set<String> splitParentRuleCodes(String ruleCode, String separator) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            set.add(ruleCode);
            String[] codes = StringUtils.split((String)ruleCode, (String)separator);
            for (int i = 1; i < codes.length; ++i) {
                String subRuleCode = Arrays.stream(codes).limit(i).collect(Collectors.joining(separator)) + separator;
                set.add(subRuleCode);
            }
        }
        return set;
    }
}

