/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.Product;
import com.biz.crm.cps.business.product.local.entity.ProductLevel;
import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.repository.ProductRepository;
import com.biz.crm.cps.business.product.local.service.ProductLevelService;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.biz.crm.cps.business.product.sdk.dto.ProductDimensionDto;
import com.biz.crm.cps.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.cps.business.product.sdk.service.ProductVoService;
import com.biz.crm.cps.business.product.sdk.vo.ProductDimensionVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductLevelVo;
import com.biz.crm.cps.business.product.sdk.vo.ProductMaterialVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProductVoServiceImpl
implements ProductVoService {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private ProductLevelService productLevelService;
    @Autowired
    private ProductMaterialService productMaterialService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public ProductDimensionVo findByProductCode(String productCode) {
        List<ProductLevel> productLevelList;
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        Product product = this.productRepository.findByProductCode(productCode);
        if (product == null) {
            return null;
        }
        ProductDimensionVo vo = (ProductDimensionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)product, ProductDimensionVo.class, Set.class, ArrayList.class, new String[0]);
        vo.setProductMaterials((Set)Sets.newHashSet());
        List<ProductMaterial> productMaterials = this.productMaterialService.findByProductCode(product.getProductCode());
        if (!CollectionUtils.isEmpty(productMaterials)) {
            List productMaterialVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productMaterials, ProductMaterial.class, ProductMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setProductMaterials((Set)Sets.newHashSet((Iterable)productMaterialVos));
        }
        if (StringUtils.isNotBlank((CharSequence)product.getProductLevelCode()) && !CollectionUtils.isEmpty(productLevelList = this.productLevelService.findAllParentsByProductLevelCode(product.getProductLevelCode()))) {
            List productLevelVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(productLevelList, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setProductLevels((Set)Sets.newHashSet((Iterable)productLevelVos));
        }
        return vo;
    }

    public String getDimensionCode(ProductDimensionDto productDimensionDto, String productLevelType) {
        if (productDimensionDto != null && !CollectionUtils.isEmpty((Collection)productDimensionDto.getProductLevels())) {
            return productDimensionDto.getProductLevels().stream().filter(item -> Objects.equals(item.getProductLevelType(), productLevelType)).findFirst().orElse(new ProductLevelDto()).getProductLevelCode();
        }
        return null;
    }
}

