/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.product.local.entity.MaterialGroupRel;
import com.biz.crm.cps.business.product.local.mapper.MaterialGroupRelMapper;
import com.biz.crm.cps.business.product.sdk.vo.MaterialGroupRelVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialGroupRelRepository
extends ServiceImpl<MaterialGroupRelMapper, MaterialGroupRel> {
    @Autowired
    private MaterialGroupRelMapper materialGroupRelMapper;

    public MaterialGroupRel findDetailsById(String id) {
        return ((MaterialGroupRelMapper)this.baseMapper).findDetailsById(id);
    }

    public List<MaterialGroupRel> findByMaterialGroupCode(String materialGroupCode) {
        return ((MaterialGroupRelMapper)this.baseMapper).findByMaterialGroupCode(materialGroupCode);
    }

    public List<MaterialGroupRel> findByMaterialCode(String materialCode) {
        return ((MaterialGroupRelMapper)this.baseMapper).findByMaterialCode(materialCode);
    }

    public void deleteByMaterialGroupCode(String materialGroupCode) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MaterialGroupRel::getMaterialGroupCode, (Object)materialGroupCode)).remove();
    }

    public List<MaterialGroupRel> findByMaterialGroupCodes(List<String> materialGroupCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MaterialGroupRel::getMaterialGroupCode, materialGroupCodes)).list();
    }

    public List<MaterialGroupRelVo> findQuantifyByTemplateCodes(List<String> templateCodes) {
        return this.materialGroupRelMapper.findQuantifyByTemplateCodes(templateCodes);
    }

    public List<MaterialGroupRelVo> findDisplayByTemplateCodes(List<String> templateCodes) {
        return this.materialGroupRelMapper.findDisplayByTemplateCodes(templateCodes);
    }

    public List<MaterialGroupRelVo> findScanByTemplateCodes(List<String> templateCodes) {
        return this.materialGroupRelMapper.findScanByTemplateCodes(templateCodes);
    }
}

