/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.Material;
import com.biz.crm.cps.business.product.local.mapper.MaterialMapper;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialRepository
extends ServiceImpl<MaterialMapper, Material> {
    @Autowired
    private MaterialMapper materialMapper;

    public Material findDetailsById(String id) {
        return ((MaterialMapper)this.baseMapper).findDetailsById(id);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Material findByMaterialCode(String materialCode) {
        return ((MaterialMapper)this.baseMapper).findByMaterialCode(materialCode);
    }

    public List<Material> findByProductLevelCode(String productLevelCode) {
        return ((MaterialMapper)this.baseMapper).findByProductLevelCode(productLevelCode);
    }

    public List<Material> findByMaterialCodes(List<String> materialCodes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"material_code", materialCodes);
        return this.list((Wrapper)queryWrapper);
    }

    public List<Material> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
    }

    public List<Material> findByProductLevelCodes(List<String> productLevelCodes) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Material::getProductLevelCode, productLevelCodes)).list();
    }

    public List<Material> findAllChildrenByRuleCodes(List<String> ruleCodes) {
        return ((MaterialMapper)this.baseMapper).findAllChildrenByRuleCodes(ruleCodes);
    }

    public List<String> findProductLevelCodeByGroupCodes(List<String> materialGroupCodes) {
        return this.materialMapper.findProductLevelCodeByGroupCodes(materialGroupCodes);
    }

    public List<Material> findByMaterialGroupCodes(List<String> dimensionCodes) {
        return this.materialMapper.findByMaterialGroupCodes(dimensionCodes);
    }

    public MaterialVo findByBarCode(String barCode) {
        return this.materialMapper.findByBarCode(barCode);
    }
}

