package com.biz.crm.cps.business.product.sdk.common.enums;


/**
 * @Description:物料维度枚举
 * @Author: hecheng
 **/
public enum MaterialDimensionEnum {
  /**
   * 大
   */
  ALL("all", "all", "全部", "1"),
  /**
   * 系列
   */
  SERIES("series", "series", "系列", "2"),
  /**
   * 大类
   */
  MAX("max", "max", "大类", "3"),
  /**
   * 细类
   */
  MIN("min", "min", "细类", "4"),
  /**
   * 物料组
   */
  MATERIAL_GROUP("materialGroup", "materialGroup", "物料组", "5"),
  /**
   * 单品
   */
  MATERIAL("material", "material", "单品", "6");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  MaterialDimensionEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }
}
