package com.biz.crm.cps.business.product.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:物料标准单位类型
 * @Author: hecheng
 **/
public enum MaterialStandardUnitTypeEnum {
  /**
   * 标箱
   */
  CASE("case", "case", "标箱", "1"),
  /**
   * 标盒
   */
  BOX("box", "box", "标盒", "2"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;


  MaterialStandardUnitTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 MaterialStandardUnitTypeEnum
   *
   * @param key
   * @return
   */
  public static MaterialStandardUnitTypeEnum getByKey(String key) {
    return Arrays.stream(MaterialStandardUnitTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
