package com.biz.crm.cps.business.product.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:物料类型
 * @Author: hecheng
 **/
public enum MaterialTypeEnum {
  /**
   * 大
   */
  BIG("big", "big", "大","1"),
  /**
   * 标准商品
   */
  BZSP("bzsp", "bzsp", "标准商品","2"),
  /**
   * 促销品
   */
  CX("cx", "cx", "促销品","3"),
  /**
   * 产成品
   */
  FINISHED_PRODUCT("finished_product", "finished_product", "产成品","4"),
  /**
   * 标准商品
   */
  MARKETING_MATERIALS("marketing_materials", "marketing_materials", "营销物料","5"),
  /**
   * 小
   */
  SMALL("small", "small", "小","6");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;


  MaterialTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ProductTypeEnum
   *
   * @param key
   * @return
   */
  public static MaterialTypeEnum getByKey(String key) {
    return Arrays.stream(MaterialTypeEnum.values()).filter(item ->Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
