package com.biz.crm.cps.business.product.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:商品层级类型
 * @Author: hecheng
 **/
public enum ProductLevelTypeEnum {
  /**
   * 品牌
   */
  BRAND("brand","brand", "品牌","1"),
  /**
   * 系列
   */
  SERIES("series","series", "系列","2"),
  /**
   * 大类
   */
  MAX("max","max", "大类","3"),
  /**
   * 细类
   */
  MIN("min","min", "细类","4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ProductLevelTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ProductLevelTypeEnum
   *
   * @param key
   * @return
   */
  public static ProductLevelTypeEnum getByKey(String key) {
    return Arrays.stream(ProductLevelTypeEnum.values()).filter(item ->Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
