package com.biz.crm.cps.business.product.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:商品上下架状态
 * @Author: hecheng
 **/
public enum ProductShelfStatusEnum {
  /**
   * 上架
   */
  Y("Y", "Y", "上架","0"),
  /**
   * 下架
   */
  N("N", "N", "下架","1"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ProductShelfStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ProductShelfStatusEnum
   *
   * @param key
   * @return
   */
  public static ProductShelfStatusEnum getByKey(String key) {
    return Arrays.stream(ProductShelfStatusEnum.values()).filter(item ->Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
