package com.biz.crm.cps.business.product.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description:商品类型
 * @Author: hecheng
 **/
public enum ProductTypeEnum {

  /**
   * 标准商品
   */
  STANDARD("standard", "standard", "标准商品","0"),
  /**
   * 范围商品
   */
  RANGE("range", "range", "范围商品","1"),
  /**
   * 礼包商品
   */
  GIFT_PACKAGE("gift_package", "gift_package", "礼包商品","2"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ProductTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ProductTypeEnum
   *
   * @param key
   * @return
   */
  public static ProductTypeEnum getByKey(String key) {
    return Arrays.stream(ProductTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }
}
