package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Set;
import lombok.Data;

/**
 * 物料维度Dto 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@ApiModel(value = "MaterialDimensionDto", description = "物料维度Dto ")
public class MaterialDimensionDto implements Serializable {
  private static final long serialVersionUID = 3598351888463679164L;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;
  /**
   * 商品所属层级
   */
  @ApiModelProperty("所属层级")
  private Set<ProductLevelDto> productLevels;

  /**
   * 商品与物料关系
   */
  @ApiModelProperty("商品与物料关系")
  private Set<ProductMaterialDto> productMaterials;

  /**
   * 物料组关系
   */
  @ApiModelProperty("物料组关系")
  private Set<MaterialGroupRelDto> materialGroupRels;

}
