package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 物料标箱信息Dto
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialStandardUnitDto", description = "物料标箱信息Dtos")
public class MaterialStandardUnitDto {

  private static final long serialVersionUID = 7755748861593003607L;
  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 码类型 1-箱码，2-盒码，3-盖内码
   */
  @ApiModelProperty("码类型")
  private String barCodeType;
  /**
   * 条码
   */
  @ApiModelProperty("条码")
  private String barCode;

}
