package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Set;
import lombok.Data;

/**
 * 商品维度Dto 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@ApiModel(value = "ProductDimensionDto", description = "商品维度Dto ")
public class ProductDimensionDto implements Serializable {
  private static final long serialVersionUID = 842264858740100174L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;
  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;
  /**
   * 商品所属层级
   */
  @ApiModelProperty("商品所属层级")
  private Set<ProductLevelDto> productLevels;

  /**
   * 商品与物料关系
   */
  @ApiModelProperty("商品与物料关系")
  private Set<ProductMaterialDto> productMaterials;

}
