package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * 商品层级Dto 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@ApiModel(value = "ProductLevelDto", description = "商品层级 包含所属 品牌 大类 细类 系列")
public class ProductLevelDto implements Serializable {
  private static final long serialVersionUID = -5318698421794146041L;
  /**
   * 商品层级code
   */
  @ApiModelProperty("商品层级code")
  private String productLevelCode;
  /**
   * 商品层级name
   */
  @ApiModelProperty("商品层级name")
  private String productLevelName;
  /**
   * 商品层级type
   */
  @ApiModelProperty("商品层级type")
  private String productLevelType;

}
