package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 商品与物料关系实体Dto
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Api(tags = "商品与物料关系实体Dto")
public class ProductMaterialDto implements Serializable {
  private static final long serialVersionUID = -7210051869749674306L;

  /**
   * 物料数量
   */
  @ApiModelProperty("物料数量")
  private Integer num;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 比例
   */
  @ApiModelProperty("比例")
  private BigDecimal ratio;

}
