package com.biz.crm.cps.business.product.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * 商品分页查询dto
 *
 * @Author: hecheng
 */
@Data
@ApiModel
public class ProductPaginationDto implements Serializable {

  private static final long serialVersionUID = 925824147679953235L;
  /**
   * 租户编号 不用向外暴露
   */
  private String tenantCode;
  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;
  /**
   * 商品名字
   */
  @ApiModelProperty("商品名字")
  private String productName;
  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;

  /**
   * 商品层级ruleCode编码
   */
  @ApiModelProperty("商品层级ruleCode编码")
  private String ruleCode;
}
