package com.biz.crm.cps.business.product.sdk.event;

import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import java.util.List;

/**
 * MaterialEventListener 维度数据操作事件通知
 *
 * @Author: hecheng
 */
public interface MaterialEventListener {

  /**
   * 当禁用时，触发事件
   *
   * @param materialVo
   * @return
   */
  String onDisable(List<MaterialVo> materialVo);

  /**
   * 当修改时，触发事件 1.productLevelCode 发生变化时
   *
   * @param oldVo
   * @param newVo
   * @return
   */
  String onChange(MaterialVo oldVo, MaterialVo newVo);
}
