package com.biz.crm.cps.business.product.sdk.event;

import com.biz.crm.cps.business.product.sdk.vo.ProductVo;
import java.util.List;

/**
 * ProductEventListener 商品数据操作事件通知
 *
 * @Author: hecheng
 */
public interface ProductEventListener {

  /**
   * 当禁用时，触发事件
   *
   * @param productVo
   * @return
   */
  String onDisable(List<ProductVo> productVo);

  /**
   * 当修改时，触发事件 1.productLevelCode 发生变化时
   *
   * @param oldVo
   * @param newVo
   * @return
   */
  String onChange(ProductVo oldVo, ProductVo newVo);
}
