package com.biz.crm.cps.business.product.sdk.service;

import com.biz.crm.cps.business.product.sdk.dto.MaterialStandardUnitDto;
import com.biz.crm.cps.business.product.sdk.vo.MaterialStandardUnitVo;
import java.util.List;

/**
 * 物料标准单位服务
 *
 * @author hecheng
 * @date 2021/09/02
 */
public interface MaterialStandardUnitVoService {

  /**
   * 查询物料标准单位描述信息
   *
   * @return
   */
  List<MaterialStandardUnitVo> findAll();

  /**
   * 查询物料标准单位描述信息
   *
   * @return
   */
  List<MaterialStandardUnitVo> findByMaterialCodeAndBarCodeType(List<MaterialStandardUnitDto> materialStandardUnitDto);
  /**
   * 按条码 和条码类型 查询物料标准单位描述信息
   *
   * @return
   */
  List<MaterialStandardUnitVo> findByBarCodeAndBarCodeType(List<MaterialStandardUnitDto> materialStandardUnitDtos);

  /**
   * 按barCode 查询标箱转换
   * @param barCodes
   * @return
   */
  MaterialStandardUnitVo findByBarCodes(List<String> barCodes);
}
