package com.biz.crm.cps.business.product.sdk.service;

import com.biz.crm.cps.business.product.sdk.dto.MaterialDimensionDto;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import java.util.List;

/**
 * 物料vo服务
 *
 * @author hecheng
 * @date 2021/08/07
 */
public interface MaterialVoService {

  /**
   * materialCode 物料编码查询物料维度信息
   * 先查询本系统是否有，没有就去拉取一次mdm的数据
   *
   * @param materialCode
   * @return
   */
  MaterialDimensionVo findByMaterialCode(String materialCode);

  /**
   * 通过维度类型 获取维度code 这些维度code 当为单品时为物料编码、为物料组时为物料组编码、
   * 全部时为MaterialDimensionConstant固定值、属于层级时为物料层级编码
   * 1。是否属于单品
   * 2。是否属于物料组
   * 3。是否是全部
   * 4。是否是层级
   * @param materialDimensionDto
   * @param dimensionType
   * @return
   */
  List<String> findDimensionCodes(MaterialDimensionDto materialDimensionDto, String dimensionType);

  /**
   * 按维度类型 和维度编码集合查询符合条件的物料编码集合
   * @param dimensionCodes
   * @param dimensionType
   * @return
   */
  List<String> findMaterialCodeByDimensionCodesAndDimensionType(List<String> dimensionCodes, String dimensionType);

  /**
   * materialCodes 物料编码集合查询物料信息
   *
   * @param materialCodes
   * @return
   */
  List<MaterialVo> findByMaterialCode(List<String> materialCodes);

  /**
   * 同步物料 这里为了不阻挡其他业务进行所以只记录日志 不抛出异常
   * @param dimensionCodes 维度编码
   * @param dimensionType 维度类型
   */
  void sync(List<String> dimensionCodes, String dimensionType);
}
